// ***********************************************************************************
// Programs written by R.Swan - rs108@mdx.ac.uk - www.netyaroze-europe.com/~middex2
// Taken from the tutorial by P.Passmore - p.passmore@mdx.ac.uk
//   Tutorial file can be found at the above web site
// Step two - put "Hello World" through the Yaroze onto the TV/Monitor
// ***********************************************************************************

// ***********************************************************************************
// Preprocessor functions
// ***********************************************************************************

// **** include libraries and files
#include <stdio.h>                                    // load standard libraries
#include <libps.h>                                    // load playstation library
#include "pad.h"                                      // load joypad reading

// **** set up defines
#define true          (1)
#define false         (0)
#define OTABLE_LENGTH (12)                            // define length of OTable
#define MAX_PACKETS   (248000)                        // define size of GPU scratchpad
#define IS_PAL_USED   (true)                          // true = PAL mode, false = NTSC mode
#define PAL_WIDTH     (320)                           // size of PAL screen
#define PAL_HEIGHT    (240)
#define NTSC_WIDTH    (320)                           // size of NTSC screen
#define NTSC_HEIGHT   (256)

// **** create global variables, structures, headers and arrays
// **** there are two OTable headers, arrays and two memory areas for GPU packet data
// **** becuase when using double buffering, each buffer must have its own
GsOT      OTable_Header[2];                           // Header files holding OTable info
GsOT_TAG  OTable_Array[2][1<<OTABLE_LENGTH];          // Array to hold drawing order info
PACKET    Packet_Memory[2][MAX_PACKETS];              // Memory to hold GPU packet data

u_long    PADstatus=0;                                // variable holds state of joypad 1

void InitialiseGraphics();                            // define graphics initialisation
void RenderWorld();                                   // define how to draw the screen


// ***********************************************************************************
// Main function
// ***********************************************************************************

void main()
  {
  FntLoad(960, 256);                                  // load font into area of frame
                                                      // specified by 960, 256
  FntOpen(-160, -120, 320, 20, 0, 512);               // specify where on screen text goes
                                                      // (0, 0) is center of screen
  PadInit();                                          // initialise joypad reading
  InitialiseGraphics();                               // initialise graphics
// **** Main loop
  while(1)
    {
    PADstatus=PadRead();                              // read status of joypad 1
    if (PADstatus & PADselect) break;                 // if select pressed, quit from loop
    RenderWorld();                                    // render the playstation screen
    }
  ResetGraph(3);                                      // clear up before quitting
  };

// ***********************************************************************************
// User defined functions
// ***********************************************************************************

// **** Setup up screen
void InitialiseGraphics()
  {
  if (IS_PAL_USED)                                    // set up PAL screen
    {
    SetVideoMode(MODE_PAL);                           // define screen as PAL
    GsInitGraph(PAL_WIDTH, PAL_HEIGHT, GsINTER|GsOFSGPU, 1, 0);
                                                      // define screen resolution, whether
                                                      // interlaced, dithered & colour depth
    GsDefDispBuff(0, 0, 0, PAL_HEIGHT);               // define top left corners of
                                                      // both screen buffers in memory
    }
  else                                                // OR set up NTSC screen
    {
    SetVideoMode(MODE_NTSC);                          // define screen as NTSC
    GsInitGraph(NTSC_WIDTH, NTSC_HEIGHT, GsINTER|GsOFSGPU, 1, 0);
    GsDefDispBuff(0, 0, 0, NTSC_HEIGHT);              // define top left corners of
                                                      // both screen buffers in memory
    };
  GsInit3D();                                         // initialise 3d graphics routine so
                                                      // 3d and font functions can work
  OTable_Header[0].length = OTABLE_LENGTH;            // notify OTable headers of OTable
  OTable_Header[1].length = OTABLE_LENGTH;            // array lengths
  OTable_Header[0].org = OTable_Array[0];             // notify OTable headers of OTable
  OTable_Header[1].org = OTable_Array[1];             // array memory locations
  GsClearOt(0, 0, &OTable_Header[0]);                 // clear out OTable sorting info
  GsClearOt(0, 0, &OTable_Header[1]);                 // ready for use (not strictly necessary
                                                      // as they are cleared before use in
                                                      // RenderWorld()
  };

// **** Actual screen drawing routine
void RenderWorld()
  {
  int currentBuffer = GsGetActiveBuff();              // determine which buffer is to be used
  GsSetWorkBase((PACKET*)Packet_Memory[currentBuffer]);
                                                      // define where screen drawing commands
                                                      // are going to be queued
  GsClearOt(0, 0, &OTable_Header[currentBuffer]);     // clear out OTable sorting info
  FntPrint("Hello World!\n");                         // send print command to queue
  FntFlush(-1);                                       // force text to be printed immediately
  DrawSync(0);                                        // wait for completion of all output
  VSync(0);                                           // wait for vertical blanking
  GsSwapDispBuff();                                   // swap buffer information
  GsSortClear(0, 0, 0,&OTable_Header[currentBuffer]); // send clear screen command to queue
  GsDrawOt(&OTable_Header[currentBuffer]);            // draw commands in queue
  };
