// Simple Trig Library for Net Yaroze N H Slaven 1998 
#define TRIG_C
#include "trig.h"


int	SignTable[4][4]=
	{
//	A, T, S, C	   Q
	0, 1, 1, 1,	// 0
	0,-1, 1,-1,	// 1
	0, 1,-1,-1, // 2
	0,-1,-1, 1  // 3
	};

int	TrigTable[257][4]={
//	A, T, S, C
	0,0,0,4096,
	4,25,25,4096,
	8,50,50,4096,
	12,75,75,4095,
	16,101,101,4095,
	20,126,126,4094,
	24,151,151,4093,
	28,176,176,4092,
	32,201,201,4091,
	36,226,226,4090,
	40,252,251,4088,
	44,277,276,4087,
	48,302,301,4085,
	52,327,326,4083,
	56,353,351,4081,
	60,378,377,4079,
	64,403,402,4076,
	68,429,427,4074,
	72,454,452,4071,
	76,480,477,4068,
	80,505,501,4065,
	84,531,526,4062,
	88,556,551,4059,
	92,582,576,4055,
	96,608,601,4052,
	100,633,626,4048,
	104,659,651,4044,
	108,685,676,4040,
	112,711,700,4036,
	116,737,725,4031,
	120,763,750,4027,
	124,789,775,4022,
	128,815,799,4017,
	132,841,824,4012,
	136,867,848,4007,
	140,894,873,4002,
	144,920,898,3996,
	148,946,922,3991,
	152,973,947,3985,
	156,999,971,3979,
	160,1026,995,3973,
	164,1053,1020,3967,
	168,1080,1044,3961,
	172,1107,1068,3954,
	176,1134,1093,3948,
	180,1161,1117,3941,
	184,1188,1141,3934,
	188,1215,1165,3927,
	192,1243,1189,3920,
	196,1270,1213,3912,
	200,1298,1237,3905,
	204,1325,1261,3897,
	208,1353,1285,3889,
	212,1381,1309,3881,
	216,1409,1333,3873,
	220,1437,1356,3865,
	224,1466,1380,3857,
	228,1494,1404,3848,
	232,1523,1427,3839,
	236,1551,1451,3830,
	240,1580,1474,3821,
	244,1609,1498,3812,
	248,1638,1521,3803,
	252,1667,1544,3794,
	256,1697,1568,3784,
	260,1726,1591,3774,
	264,1756,1614,3765,
	268,1786,1637,3755,
	272,1816,1660,3745,
	276,1846,1683,3734,
	280,1876,1706,3724,
	284,1907,1729,3713,
	288,1938,1751,3703,
	292,1968,1774,3692,
	296,1999,1797,3681,
	300,2031,1819,3670,
	304,2062,1842,3659,
	308,2094,1864,3647,
	312,2125,1887,3636,
	316,2157,1909,3624,
	320,2190,1931,3612,
	324,2222,1953,3600,
	328,2255,1975,3588,
	332,2288,1997,3576,
	336,2321,2019,3564,
	340,2354,2041,3551,
	344,2388,2063,3539,
	348,2421,2084,3526,
	352,2455,2106,3513,
	356,2490,2128,3500,
	360,2524,2149,3487,
	364,2559,2170,3474,
	368,2594,2192,3460,
	372,2630,2213,3447,
	376,2665,2234,3433,
	380,2701,2255,3419,
	384,2737,2276,3406,
	388,2774,2297,3391,
	392,2811,2318,3377,
	396,2848,2338,3363,
	400,2885,2359,3349,
	404,2923,2379,3334,
	408,2961,2400,3319,
	412,3000,2420,3305,
	416,3038,2440,3290,
	420,3077,2460,3275,
	424,3117,2480,3260,
	428,3157,2500,3244,
	432,3197,2520,3229,
	436,3238,2540,3213,
	440,3279,2560,3198,
	444,3320,2579,3182,
	448,3362,2599,3166,
	452,3404,2618,3150,
	456,3447,2637,3134,
	460,3490,2657,3118,
	464,3534,2676,3101,
	468,3578,2695,3085,
	472,3623,2714,3068,
	476,3668,2732,3051,
	480,3713,2751,3035,
	484,3759,2770,3018,
	488,3806,2788,3001,
	492,3853,2806,2984,
	496,3900,2825,2966,
	500,3949,2843,2949,
	504,3997,2861,2931,
	508,4047,2879,2914,
	512,4097,2897,2896,
	516,4147,2914,2878,
	520,4199,2932,2860,
	524,4251,2949,2842,
	528,4303,2967,2824,
	532,4356,2984,2806,
	536,4410,3001,2787,
	540,4465,3018,2769,
	544,4520,3035,2750,
	548,4576,3052,2732,
	552,4633,3069,2713,
	556,4691,3085,2694,
	560,4749,3102,2675,
	564,4809,3118,2656,
	568,4869,3134,2637,
	572,4930,3151,2617,
	576,4992,3167,2598,
	580,5055,3182,2579,
	584,5119,3198,2559,
	588,5184,3214,2539,
	592,5250,3229,2520,
	596,5317,3245,2500,
	600,5385,3260,2480,
	604,5454,3275,2460,
	608,5524,3290,2440,
	612,5596,3305,2419,
	616,5668,3320,2399,
	620,5742,3335,2379,
	624,5817,3349,2358,
	628,5894,3364,2337,
	632,5972,3378,2317,
	636,6051,3392,2296,
	640,6132,3406,2275,
	644,6214,3420,2254,
	648,6298,3434,2233,
	652,6383,3447,2212,
	656,6470,3461,2191,
	660,6559,3474,2170,
	664,6649,3487,2148,
	668,6742,3501,2127,
	672,6836,3514,2105,
	676,6932,3526,2084,
	680,7030,3539,2062,
	684,7130,3552,2040,
	688,7233,3564,2018,
	692,7337,3576,1997,
	696,7444,3589,1975,
	700,7554,3601,1952,
	704,7666,3613,1930,
	708,7780,3624,1908,
	712,7897,3636,1886,
	716,8017,3648,1864,
	720,8140,3659,1841,
	724,8266,3670,1819,
	728,8395,3681,1796,
	732,8528,3692,1773,
	736,8664,3703,1751,
	740,8803,3714,1728,
	744,8946,3724,1705,
	748,9093,3735,1682,
	752,9244,3745,1659,
	756,9399,3755,1636,
	760,9559,3765,1613,
	764,9724,3775,1590,
	768,9893,3784,1567,
	772,10067,3794,1544,
	776,10247,3803,1520,
	780,10432,3813,1497,
	784,10623,3822,1474,
	788,10821,3831,1450,
	792,11025,3840,1427,
	796,11235,3848,1403,
	800,11453,3857,1379,
	804,11679,3865,1356,
	808,11912,3873,1332,
	812,12154,3882,1308,
	816,12406,3889,1284,
	820,12666,3897,1260,
	824,12937,3905,1236,
	828,13218,3912,1212,
	832,13511,3920,1188,
	836,13816,3927,1164,
	840,14133,3934,1140,
	844,14465,3941,1116,
	848,14811,3948,1092,
	852,15173,3954,1068,
	856,15551,3961,1043,
	860,15948,3967,1019,
	864,16364,3973,995,
	868,16801,3979,970,
	872,17261,3985,946,
	876,17745,3991,921,
	880,18255,3997,897,
	884,18794,4002,872,
	888,19365,4007,848,
	892,19969,4012,823,
	896,20611,4017,798,
	900,21294,4022,774,
	904,22022,4027,749,
	908,22799,4031,724,
	912,23631,4036,700,
	916,24525,4040,675,
	920,25486,4044,650,
	924,26524,4048,625,
	928,27648,4052,600,
	932,28869,4055,575,
	936,30201,4059,550,
	940,31658,4062,526,
	944,33261,4065,501,
	948,35032,4068,476,
	952,36999,4071,451,
	956,39197,4074,426,
	960,41669,4076,401,
	964,44470,4079,376,
	968,47672,4081,351,
	972,51366,4083,326,
	976,55675,4085,301,
	980,60770,4087,275,
	984,66884,4088,250,
	988,74361,4090,225,
	992,83713,4091,200,
	996,95747,4092,175,
	1000,111812,4093,150,
	1004,134342,4094,125,
	1008,168227,4095,100,
	1012,224950,4095,75,
	1016,339344,4096,49,
	1020,690362,4096,24,
	1024,20110647,4096,0
	};


void TrigTest(void)
{
int		TE,TS,i;
int		Angle;

TS=VSync(1);
FntPrint("Deg  PSX      TAN/ATAN   COS/ACOS    SIN/ASIN   ISqrt(PSX)\n");
for(i=0;i<360;i+=40)
	{
	Angle=Deg2PSX(i);
	FntPrint("%03d %04d %08d/%04d %05d/%05d %05d/%05d    %d\n",
		i,Angle,
		TanP(Angle),ATanP(TanP(Angle)),
		CosP(Angle),ACosP(CosP(Angle)),
		SinP(Angle),ASinP(SinP(Angle)),
		ISqrt(Angle)
		);
	}
TE=VSync(1);
FntPrint("Time %d\n\n",TE-TS);
}



inline int Interpolate(int I,int S,int R,int V,int di)
{
register int IP,dV,dR,dS;

IP=(I+di) & 255;

dR=di*(TrigTable[IP][R]-TrigTable[I][R]);
dS=di*(TrigTable[IP][S]-TrigTable[I][S]);
dV=di*(               V-TrigTable[I][S]);

return (TrigTable[I][R]+((dR*dV)/dS));
}




int	LookUp(int Return,int Search,int Val)
{
register int	Step,Index;

Index=Step=128;

if(Search==T_COS)
	while(Step)
		{
		if(TrigTable[Index][Search]==Val)	break;
		if(TrigTable[Index][Search]>Val)	Index+=Step;
		else								Index-=Step;
		Step=Step>>1;		
		}
else
	while(Step)
		{
		if(TrigTable[Index][Search]==Val)	break;
		if(TrigTable[Index][Search]<Val)	Index+=Step;
		else								Index-=Step;
		Step=Step>>1;		
		}

if(Step>0)	
	return TrigTable[Index][Return];
	
if(TrigTable[Index][Search]<Val)	return Interpolate(Index,Search,Return,Val,(Search!=T_COS)? 1:-1);
else								return Interpolate(Index,Search,Return,Val,(Search!=T_COS)?-1: 1);
}

	
int GetTrig(int Table,int PSXAngle)
{
int	Quad,Trig;

PSXAngle&=4095;
Quad=PSXAngle>>10;
switch(Quad)
	{
	case 0:Trig=LookUp(Table,T_ANGLE,         PSXAngle);break;
	case 1:Trig=LookUp(Table,T_ANGLE,2048    -PSXAngle);break;
	case 2:Trig=LookUp(Table,T_ANGLE,PSXAngle-    2048);break;
	case 3:Trig=LookUp(Table,T_ANGLE,4096    -PSXAngle);break;
	}
return Trig*SignTable[Quad][Table];
}


int ATanP(int CTan)
{
int	Angle;
Angle=LookUp(T_ANGLE,T_TAN,fabs(CTan));
if(CTan<0)	Angle=4096-Angle;
return Angle;
}


int ASinP(int CSin)
{
int	Angle;
Angle=LookUp(T_ANGLE,T_SIN,fabs(CSin));
if(CSin<0)	Angle=4096-Angle;
return Angle;
}


int ACosP(int CCos)
{
int	Angle;
Angle=LookUp(T_ANGLE,T_COS,fabs(CCos));
if(CCos<0)	Angle=2048-Angle;
return Angle;
}



u_long VectorLength(VECTOR * V)
{
u_long Sum;

Sum=V->vx*V->vx + V->vy*V->vy + V->vy*V->vy;
Sum=ISqrt(Sum);
return Sum;
}


u_long ISqrt(u_long X)
{
register int 	bitmax,Step=0;
register u_long V1,V2=0;

// get 1st estimate
for(bitmax=0,V1=X;V1!=0;bitmax++)
	V1>>=1;
V1=X>>(bitmax>>1);

// iterative approximation (takes about 4 steps, Step is for unequal values of V1&V2)
while((V1!=V2)&&(Step++<10))
	{
	V2=X/V1;
	V1=(V1+V2)>>1;
	}
return V1;
}


int DeltaAngle(int Current,int New)
{
int	DA;
DA =(New-Current);
if(DA> 2048) DA-=4096;
if(DA<-2048) DA+=4096;
return DA;
}


