// Simple Trig Library for Net Yaroze N H Slaven 1998 

#ifndef TRIG_H
#define TRIG_H
#include <libps.h>

#define 	T_ANGLE	0
#define		T_TAN	1
#define		T_SIN	2
#define 	T_COS	3

// GNU treats inline function slightly differently to CW
// so if you have GNU uncomment the following line
//#define GNU_C	

#ifdef GNU_C //we have GNU compiler
	#define NHS_inline	extern inline
#else
	#define NHS_inline 	inline
#endif

int				ATanP(int CTan);
int				ASinP(int CSin);
int				ACosP(int CCos);
int				GetTrig(int Table,int PSXAngle);
NHS_inline int	Deg2PSX(int DegAngle)	{return (((DegAngle % 360) * ONE)/360);}
NHS_inline int	PSX2Deg(int PSXAngle)	{return ((PSXAngle&4095)*360)>>12;}
NHS_inline int	TanP(int PSXAngle)		{return GetTrig(T_TAN,PSXAngle);}
NHS_inline int	SinP(int PSXAngle)		{return GetTrig(T_SIN,PSXAngle);}
NHS_inline int	CosP(int PSXAngle)		{return GetTrig(T_COS,PSXAngle);}
NHS_inline int	TanD(int DegAngle)		{return TanP(Deg2PSX(DegAngle));}
NHS_inline int	SinD(int DegAngle)		{return SinP(Deg2PSX(DegAngle));}
NHS_inline int	CosD(int DegAngle)		{return CosP(Deg2PSX(DegAngle));}
NHS_inline int	ATanD(int CTan)			{return PSX2Deg(ATanP(CTan));}
NHS_inline int	ASinD(int CSin)			{return PSX2Deg(ASinP(CSin));}
NHS_inline int	ACosD(int CCos)			{return PSX2Deg(ACosP(CCos));}

u_long		ISqrt(u_long X);
u_long 		VectorLength(VECTOR * V);
int 		DeltaAngle(int Current,int New);

void		TrigTest(void);

#ifndef TRIG_C
#endif

#endif