// Filename		: TMDVIEW.H
// Coded by		: Scott Evans
// Created/Modified	: 13/11/97
// Description		: Header file for tmdview.c

#ifndef _TMDVIEW_H_
#define _TMDVIEW_H_

// Build Yaroze version if defined

#define YAROZE
 
#ifndef YAROZE

#include 	<sys/types.h>
#include	<kernel.h>
#include	<libetc.h>
#include	<libgte.h>
#include	<libgpu.h>
#include	<libgs.h>
#include	<libsnd.h>

#else

#include <libps.h>

// PSX standard controller values 

#define PADLleft	(1<<15)
#define PADLdown	(1<<14)
#define PADLright	(1<<13)
#define PADLup		(1<<12)
#define PADstart	(1<<11)
#define PADselect	(1<<8)
#define PADRleft	(1<<7)
#define PADRdown	(1<<6)
#define PADRright	(1<<5)
#define PADRup		(1<<4)
#define PADR1		(1<<3)
#define PADL1		(1<<2)
#define PADR2		(1<<1)
#define PADL2		(1<<0)

#endif

// Screen size

#define SCRNW	320
#define SCRNH	240
#define SCRNZ	256

// Screen position offsets

#define SCRN_XOFF	16
#define SCRN_YOFF	16

// Ordering table and packet buffer stuff

#define OTSIZE	10
#define MAXPKS	2000
#define PKSIZE	24
#define PBSIZE	(PKSIZE*MAXPKS)

// Address of TMD file in memory

#define TMDADDR	0x80090000

// Double buffer structure

typedef struct
{
	DISPENV dispenv;	// Current display environment 	
	DRAWENV drawenv;	// Current drawing environment
	GsOT	*ot;			// Pointer to ordering table
	PACKET 	*pb;		// Pointer to packet buffer
}DBUFFER;

// TMD model object structure

typedef struct
{
	GsDOBJ2 		handler;		// TMD object handler
	GsCOORDINATE2 	co_system;	// Coordinate system for object
	VECTOR		pos;			// Objects position
	SVECTOR		angle;		// Objects angle
}TMD_OBJECT;

// Function prototypes

void InitSystem(DBUFFER *,GsOT *,GsOT_TAG *tags);
TMD_OBJECT *InitTMD_OBJECT(unsigned long,int);
GsRVIEW2 *InitRefView(int,int,int,int,int,int,int);
GsF_LIGHT *InitLights(SVECTOR *,CVECTOR *);
void ControlObject(TMD_OBJECT *,unsigned long);
void ControlView(GsRVIEW2 *,unsigned long);
void InitFont(long,long);

#ifdef YAROZE

void PadInit(unsigned short);
unsigned long PadRead(unsigned short);

#endif

#endif
