#include "header.h"

void UpdateRacer(VECTOR *pos, SVECTOR *rot, GsCOORDINATE2 *coordSystem) {
	ResetMatrix(coordSystem->coord.m);
	RotMatrixX(rot->vx, &coordSystem->coord);
	RotMatrixZ(rot->vz, &coordSystem->coord);
	RotMatrixY(rot->vy, &coordSystem->coord);

	coordSystem->coord.t[0] = pos->vx>>8;
	coordSystem->coord.t[1] = pos->vy>>8;
	coordSystem->coord.t[2] = pos->vz>>8;
	coordSystem->flg = 0;
}


void MoveObject(VECTOR *pos, SVECTOR *rot, GsCOORDINATE2 *coordSystem) {
	ResetMatrix(coordSystem->coord.m);
	RotMatrixX(rot->vx, &coordSystem->coord);
	RotMatrixZ(rot->vz, &coordSystem->coord);
	RotMatrixY(rot->vy, &coordSystem->coord);

	coordSystem->coord.t[0] = pos->vx;
	coordSystem->coord.t[1] = pos->vy;
	coordSystem->coord.t[2] = pos->vz;
	coordSystem->flg = 0;
}


void LinkObject(u_long *adr, GsCOORDINATE2 *coord, GsDOBJ2 *handler) {
	u_long *pointer;
	
	GsInitCoordinate2(WORLD, coord);
	pointer = adr;
	pointer++;
	GsMapModelingData(pointer);
	pointer += 2;
	GsLinkObject4((u_long )pointer, handler, 0);
	handler->attribute = 0;
	handler->coord2 = coord;
}


void ResetMatrix(short m[3][3]) {
	m[0][0] = m[1][1] = m[2][2] = ONE;
	m[0][1] = m[0][2] = m[1][0] = 0;
	m[1][2] = m[2][0] = m[2][1] = 0;
}