#include "header.h"

volatile u_char *bb0, *bb1;

int CorrectStick(int val);


void InitPad(void) {
	GetPadBuf(&bb0, &bb1);
}


void ReadPad(PadInfo *pad) {
	pad->button = ~(*(bb0+3) | *(bb0+2)<<8 | *(bb1+3)<<16 | *(bb1+2)<<24);
	pad->rightStickH = CorrectStick(*(bb0+4));
	pad->rightStickV = CorrectStick(*(bb0+5));
	pad->leftStickH = CorrectStick(*(bb0+6));
	pad->leftStickV = CorrectStick(*(bb0+7));
	pad->mode = (*(bb0+1))&15;
}


int CorrectStick(int val) {
	val -= 128;

	if (Abs(val) < 20)
		val = 0;
	else {
		if (val < 0)
			val += 20;
		else
			val -= 20;
	}

	return val;
}