#include "header.h"

#define BACK_WIDTH			(16)
#define BACK_HEIGHT			(8)

NS_GP_QUAD_FACE backPrim[BACK_WIDTH*BACK_HEIGHT];
VERTEX backVert[BACK_WIDTH*(BACK_HEIGHT+1)];
u_long backTMD[40];
GsDOBJ2 backHandler;
GsCOORDINATE2 backCoord;
u_char skyCol[(BACK_HEIGHT+1)*6] = {
	10, 50, 150,	190, 210, 240,
	25, 75, 170,	190, 210, 240,
	40, 100, 190,	190, 210, 240,
	55, 125, 210,	190, 210, 240,
	55, 125, 210,	10, 150, 20,
	10, 150, 20,	0, 100, 0,
	5, 135, 10,		0, 90, 0,
	0, 120, 0,		0, 80, 0,
	0, 105, 0,		0, 105, 0
};


void InitBackground(void) {
	int i, j, r, g, b, a, c, d;
	MATRIX tm;
	COLOUR backCol[BACK_WIDTH*(BACK_HEIGHT+1)];
	OBJECT *obj;
	
	// Init verticies & colours
	for (j=0; j<BACK_HEIGHT+1; j++) {
		for (i=0; i<BACK_WIDTH; i++) {
			tm.m[0][0] = 0;
			tm.m[1][0] = 0;
			tm.m[2][0] = 10240;
			RotMatrixX(j*900/BACK_HEIGHT+1024+430+(rand()&63), &tm);
			RotMatrixY(i*4096/BACK_WIDTH+(rand()&63), &tm);
			SetVertex(&backVert[i+(j*BACK_WIDTH)], tm.m[0][0], tm.m[1][0], tm.m[2][0]);
			a = rand()&255;
			r = ((skyCol[j*6]<<8)+(a*(skyCol[j*6+3]-skyCol[j*6])))>>8;
			g = ((skyCol[j*6+1]<<8)+(a*(skyCol[j*6+4]-skyCol[j*6+1])))>>8;
			b = ((skyCol[j*6+2]<<8)+(a*(skyCol[j*6+5]-skyCol[j*6+2])))>>8;
			SetRGB(&backCol[i+((BACK_HEIGHT-j)*BACK_WIDTH)], r, g, b);
		}
	}
	
	// Build TMD
	PrepareTMD(&backVert[0], &backCol[0], NULL);
	SetTmdHeader((HEADER *)backTMD);
	obj = (OBJECT *)((HEADER *)backTMD + 1);

	for (i=0; i<BACK_WIDTH; i++) {
		for (j=0; j<BACK_HEIGHT; j++) {
			a = i + (j*BACK_WIDTH);
			b = ((i+1)%BACK_WIDTH) + (j*BACK_WIDTH);
			c = i + ((j+1)*BACK_WIDTH);
			d = ((i+1)%BACK_WIDTH) + ((j+1)*BACK_WIDTH);
			SetNS_GP_QUAD(&backPrim[i+(j*BACK_WIDTH)], a, b, c, d, a, b, c, d);
		}
	}
	
	obj->vert_top = (u_long *)&backVert[0];
	obj->n_vert = 7;
	obj->normal_top = (u_long *)NULL;
	obj->n_normal = 0;
	obj->primitive_top = (u_long *)&backPrim[0];
	obj->n_primitive = BACK_WIDTH*BACK_HEIGHT;
	obj->scale = 0;
	
	LinkObject((u_long *)backTMD, &backCoord, &backHandler);
	backHandler.attribute = (2<<9);
}


void DrawBackground(GsOT *ot) {
	MATRIX ls;
	
	
	ResetMatrix(backCoord.coord.m);
	backCoord.coord.t[0] = racer.pos.vx>>8;
	backCoord.coord.t[1] = racer.pos.vy>>8;
	backCoord.coord.t[2] = racer.pos.vz>>8;
	backCoord.flg = 0;

	GsGetLs(&backCoord, &ls);
	GsSetLsMatrix(&ls);
	GsSortObject4(&backHandler, ot, 0, getScratchAddr(0));
}










