#include "header.h"

// Environment mapping rountine based on Craig Graham's algorithm
void EnvMap(GsDOBJ2 *object) {
	OBJECT *ob = (OBJECT *)object->tmd;
	SVECTOR t;
	int p;
	register TX_GP_TRI_FACE *prim;
	register short temp;
	register unsigned char *tu_buf, *tv_buf;
	MATRIX rotMatrix;
	
	prim = (TX_GP_TRI_FACE*)ob->primitive_top;
	// Get scratch pad address (there's only 29 normals)
	tu_buf=(unsigned char*)getScratchAddr(0);
	tv_buf=(unsigned char*)getScratchAddr(512/4);
	
 	// Get rotation matrix for normals
 	// I assume (gte_SetRotMatrix(&object->coord2->workm)) does the same thing
	RotMatrix(&racer.rot, &rotMatrix);
	// Calculate texture UV's for all vertices, and build a lookup
	for (p=0; p<ob->n_normal; p++) {
		// Rotate the normal and put result in temporary vector
		ApplyMatrixSV(&rotMatrix, (SVECTOR*)&ob->normal_top[p], &t);
		// Get texture u,v coords from normal orientation
		temp = t.vx;
		temp >>= 7;
		temp += 32;
		tu_buf[p] = temp;
		temp = t.vy;
		temp >>= 7;
		temp += 32;
		tv_buf[p] = temp;
	
	}
	// Now go round all poly's and fill in the UV's from the lookup we've already built
	for (p=0; p<ob->n_primitive; p++) {
		// No need to check primitive type as they are all the same (in this model)
		prim->u0 = tu_buf[prim->norm0];
		prim->u1 = tu_buf[prim->norm1];
		prim->u2 = tu_buf[prim->norm2];
		prim->v0 = tv_buf[prim->norm0];
		prim->v1 = tv_buf[prim->norm1];
		prim->v2 = tv_buf[prim->norm2];
		prim++;
	}
}