#include <libps.h>
#include "MyPad.h"
#include "tmd.h"
#include "Address.h"

#define OT_LENGTH			(12)
#define PACKETMAX			(8192)
#define PACKETMAX2			(PACKETMAX*24) 
#define SCREEN_WIDTH		(512)
#define SCREEN_HEIGHT		(256)

#define MAX_SEGMENTS		(1023)
#define SEGMENT_LENGTH		(64)
#define SEGMENT_WIDTH		(512)
#define SIDE_HEIGHT			(128)
#define SIDE_WIDTH			(80)
#define SIDE_OFFSET			((MAX_SEGMENTS+1)*2)
#define REST_OFFSET			((MAX_SEGMENTS+1)*4)
#define MAX_PARTICLE_TYPES	(16)
#define MAX_PARTICLES		(256)
#define MAX_SPEED			(128<<8)
#define MAX_OBJECTS			(64)

#define NO_MORE				(-1)
#define BLOCK				(0)
#define FACTORY				(1)
#define HIRISE				(2)
#define PYRAMID				(3)
#define TOWER				(4)

#define TMD_DYNAMIC_START	(0x800d0000)

#define DotProduct(a, b) ( ((a).vx*(b).vx) + ((a).vy*(b).vy) + ((a).vz*(b).vz) )
#define LimitRange(a, b, c) ( ((a)<(b)) ? (b) : ((a)>(c) ? (c) : (a)) )
#define Greater(a, b) ( (a) = ((a) < (b)) ? (b) : (a) )
#define Less(a, b) ( (a) = ((a) > (b)) ? (b) : (a) )
#define Abs(a) ( ((a) < 0) ? (-(a)) : (a) )
#define Sgn(a) ( ((a) == 0) ? (0) : ((a)>0)*2-1 )
#define SgnRand() ( ((rand()&1)*2)-1 )
#define SetVector(v, x, y, z) \
	(v)->vx = (x), \
	(v)->vy = (y), \
	(v)->vz = (z)
#define SetRGB(c, _r, _g, _b) \
	(c)->r = (_r), \
	(c)->g = (_g), \
	(c)->b = (_b)
#define SetRGB0(c, _r, _g, _b) \
	(c)->r0 = (_r), \
	(c)->g0 = (_g), \
	(c)->b0 = (_b)
#define CrossProduct(a, b, c) \
	(c)->vx = ( (a)->vy*(b)->vz - (a)->vz*(b)->vy ), \
	(c)->vy = ( (a)->vz*(b)->vx - (a)->vx*(b)->vz ), \
	(c)->vz = ( (a)->vx*(b)->vy - (a)->vy*(b)->vx )
#define SqrtStep(k) s=r+(1L<<k*2);r>>=1;if(s<=v){v-=s;r|=(1L<<k*2);}


typedef struct {
	GsDOBJ2	handler;
	VECTOR pos;
	SVECTOR rot;
	GsCOORDINATE2 coord;
} ObjectHandler;

typedef struct {
	u_long button;
	int leftStickV, leftStickH;
	int rightStickV, rightStickH;
	u_char mode;
} PadInfo;

typedef struct {
	GsDOBJ2 handler[MAX_SEGMENTS];
	GsCOORDINATE2 coord;
} TrackData;

typedef struct {
	u_long numSegments;
	u_long info[MAX_SEGMENTS];
} SegmentInfo;

typedef struct {
	GsDOBJ2	handler, reflectHandler, flameHandler, shadowHandler;
	VECTOR pos, oldPos, vel;
	VECTOR trail[4];
	VECTOR collisionPoint[3], heightPoint[4];
	SVECTOR rot;
	GsCOORDINATE2 coord, shadowCoord;
	int speed, tilt;
	int heightOffTrack, collisionSegment[3], heightSegment[4];
	int half[4], height[4], heightVel[4];
} RacerHandler;

typedef struct {
	long sx, sy, ex, ey;
} Line;

typedef struct {
	u_char type, frame;
	VECTOR pos;
	SVECTOR vel;
} Particle;

typedef struct {
	int numObjects, x[MAX_OBJECTS], z[MAX_OBJECTS];
	short rot[MAX_OBJECTS];
	GsDOBJ2	handler[MAX_OBJECTS];
	GsCOORDINATE2 coord[MAX_OBJECTS];
} TrackObjectHandler;

typedef struct {
	int type, segment, dis, height, rot;
} TrackObjectInfo;


extern GsOT WorldOT[2];	
extern PACKET packetArea[2][PACKETMAX2];
extern PadInfo pad;
extern TrackData trackData;
extern VERTEX vertexLut[(MAX_SEGMENTS+1)*6];
extern TX_NS_FP_TRI_FACE primitiveLut[MAX_SEGMENTS*12];
extern GsRVIEW2 view;
extern SegmentInfo *rawTrack;
extern RacerHandler racer;
extern int projection;
extern GsIMAGE racerTexInfo, reflectTexInfo, trackTexInfo;
extern SVECTOR camRot;
extern TrackObjectHandler trackObjects;

// Track.c
void InitTrack(void);
void MakeTrack(void);
void DrawTrack(GsOT *ot, int offset);
void DrawTrackObjects(GsOT *ot, int offset);

// 3d.c
void UpdateRacer(VECTOR *pos, SVECTOR *rot, GsCOORDINATE2 *coordSystem);
void MoveObject(VECTOR *pos, SVECTOR *rot, GsCOORDINATE2 *coordSystem);
void LinkObject(u_long *adr, GsCOORDINATE2 *coord, GsDOBJ2 *handler);
void ResetMatrix(short m[3][3]);

// Racer.c
void InitRacer(void);
void DrawRacer(GsOT *ot, int shift);

// Env.c
void EnvMap(GsDOBJ2 *object);

// Math.c
void GetHeight(void);
int LineCollision(Line a, Line b);
int TrackCollide(void);
long InvTan(long x, long y);
long FindRotation(long height1, long height2, long length);
u_long IntSqrt(u_long n);

// Sprite.c
void Draw3dSprite(VECTOR *pos, GsSPRITE *sprite, GsOT *ot, long scale, int priority);
void LoadTexture(long TIMdata, GsIMAGE *imageInfo);
void InitParticle(int x, int y);
void AddStreamParticle(void);
void DrawParticles(GsOT *ot, int priority);

// Background.c
void InitBackground(void);
void DrawBackground(GsOT *ot);