#include "header.h"

//------------------------------------
// Globals
//------------------------------------
VERTEX *VERTEX_LUT;
COLOUR *COLOUR_LUT;
TEXTURE *TEXTURE_LUT;


//------------------------------------
// Function definitions
//------------------------------------

// Prepare for the creation of a new tmd
void PrepareTMD(VERTEX *vertex, COLOUR *colour, TEXTURE *texture) {
	VERTEX_LUT = vertex;
	COLOUR_LUT = colour;
	TEXTURE_LUT = texture;
}


void SetTexture(TEXTURE *t, u_short tx, u_short ty, u_char _x0, u_char _y0, u_char _x1, u_char _y1, u_char _x2, u_char _y2, u_char _x3, u_char _y3, int _pmode, u_short _cx, u_short _cy) {
	(t)->px = (tx);
	(t)->py = (ty);
	(t)->x[0] = (_x0);
	(t)->y[0] = (_y0);
	(t)->x[1] = (_x1);
	(t)->y[1] = (_y1);
	(t)->x[2] = (_x2);
	(t)->y[2] = (_y2);
	(t)->x[3] = (_x3);
	(t)->y[3] = (_y3);
	(t)->pmode = (_pmode);
	(t)->cx = (_cx);
	(t)->cy = (_cy);
}

// Add a flat-tinted quad to tmd
/*void SetNS_FP_QUAD(NS_FP_QUAD_FACE *newPoly, u_short v0, u_short v1, u_short v2, u_short v3, u_short c0) {
	SetPrimitiveHeader(newPoly, NS_FP_QUAD, 1, 3, 5);
	newPoly->mode2 = NS_FP_QUAD;
	newPoly->vert0 = v0;
	newPoly->vert1 = v1;
	newPoly->vert2 = v2;
	newPoly->vert3 = v3;
	SetColour0();
}


// Add a segment to tmd
void SetTX_NS_FP_QUAD(TX_NS_FP_QUAD_FACE *newPoly, u_short v0, u_short v1, u_short v2, u_short v3, u_short c0, int tex) {
	TEXTURE *texture = TEXTURE_LUT + tex;
	int tPageX=1024, tPageY=512, i;

	// Get texture page ID
	for (i=0; i<4; i++) {
		if (tPageX > texture->x[i])
			tPageX = texture->x[i];
		if (tPageY > texture->y[i])
			tPageY = texture->y[i];
	}
	tPageX = tPageX>>6;
	tPageX = tPageX<<6;
	tPageY = tPageY>>8;
	tPageY = tPageY<<8;
	newPoly->tsb = GetTPage(texture->pmode, 0, tPageX, tPageY);
	newPoly->cba = ((texture->cx)>>4) + ((texture->cy)<<6);

	SetPrimitiveHeader(newPoly, TX_NS_FP_QUAD, 1, 7, 9);
	newPoly->vert0 = v0;
	newPoly->vert1 = v1;
	newPoly->vert2 = v2;
	newPoly->vert3 = v3;
	newPoly->u0 = (u_char )(texture->x[0] - tPageX);
	newPoly->v0 = (u_char )(texture->y[0] - tPageY);
	newPoly->u1 = (u_char )(texture->x[1] - tPageX);
	newPoly->v1 = (u_char )(texture->y[1] - tPageY);
	newPoly->u2 = (u_char )(texture->x[2] - tPageX);
	newPoly->v2 = (u_char )(texture->y[2] - tPageY);
	newPoly->u3 = (u_char )(texture->x[3] - tPageX);
	newPoly->v3 = (u_char )(texture->y[3] - tPageY);
	SetColour0();
}*/


// Add a segment to tmd
void MakeSegment(TX_NS_FP_TRI_FACE *newPoly, u_short v0, u_short v1, u_short v2, u_short v3, u_short c0, int tex) {
	TEXTURE *texture = TEXTURE_LUT + tex;
	int tPageX=1024, tPageY=512;

	tPageX = texture->px>>6;
	tPageX = tPageX<<6;
	tPageY = texture->py>>8;
	tPageY = tPageY<<8;
	
	// Create first tri
	SetPrimitiveHeader(newPoly, TX_NS_FP_TRI, 1, 6, 7);
	newPoly->tsb = GetTPage(texture->pmode, 1, tPageX, tPageY);
	newPoly->cba = ((texture->cx)>>4) + ((texture->cy)<<6);
	newPoly->vert0 = v0;
	newPoly->vert1 = v1;
	newPoly->vert2 = v2;
	newPoly->u0 = (u_char )texture->x[0];
	newPoly->v0 = (u_char )texture->y[0];
	newPoly->u1 = (u_char )texture->x[1];
	newPoly->v1 = (u_char )texture->y[1];
	newPoly->u2 = (u_char )texture->x[2];
	newPoly->v2 = (u_char )texture->y[2];
	SetColour0();
	
	// Create second tri
	newPoly = &newPoly[1];
	SetPrimitiveHeader(newPoly, TX_NS_FP_TRI, 1, 6, 7);
	newPoly->tsb = GetTPage(texture->pmode, 1, tPageX, tPageY);
	newPoly->cba = ((texture->cx)>>4) + ((texture->cy)<<6);
	newPoly->vert0 = v2;
	newPoly->vert1 = v1;
	newPoly->vert2 = v3;
	newPoly->u0 = (u_char )texture->x[2];
	newPoly->v0 = (u_char )texture->y[2];
	newPoly->u1 = (u_char )texture->x[1];
	newPoly->v1 = (u_char )texture->y[1];
	newPoly->u2 = (u_char )texture->x[3];
	newPoly->v2 = (u_char )texture->y[3];
	SetColour0();
}


// Create flame
void MakeFlame(TX_NS_GP_TRI_FACE *newPoly) {
	TEXTURE texture;
	int tPageX=1024, tPageY=512, i;
	int c0=1, c1=0, c2=1;
	int px, py, cx, cy;

	px = racerTexInfo.px;
	py = racerTexInfo.py;
	cx = racerTexInfo.cx;
	cy = racerTexInfo.cy;
	SetTexture(&texture, px, py, 0, 0, 1, 0, 0, 1, 1, 1, 0, cx, cy);
	tPageX = px>>6;
	tPageX = tPageX<<6;
	tPageY = py>>8;
	tPageY = tPageY<<8;
	
	// Create tri's
	for (i=0; i<3; i++) {
//		c0=0; c1=1; c2=0;
		c0 = c1 = c2=0;
		SetPrimitiveHeader(newPoly, TX_NS_GP_TRI, 1, 8, 9);
		newPoly->tsb = GetTPage(texture.pmode, 1, tPageX, tPageY);
		newPoly->cba = ((texture.cx)>>4) + ((texture.cy)<<6);
		newPoly->vert0 = i*2;
		newPoly->vert1 = (i*2+1)%6;
		newPoly->vert2 = (i*2+2)%6;
		newPoly->u0 = (u_char )texture.x[0];
		newPoly->v0 = (u_char )texture.y[0];
		newPoly->u1 = (u_char )texture.x[1];
		newPoly->v1 = (u_char )texture.y[1];
		newPoly->u2 = (u_char )texture.x[2];
		newPoly->v2 = (u_char )texture.y[2];
		SetColour0();
		SetColour1();
		SetColour2();
	
		newPoly = &newPoly[1];
		SetPrimitiveHeader(newPoly, TX_NS_GP_TRI, 1, 8, 9);
		newPoly->tsb = GetTPage(texture.pmode, 1, tPageX, tPageY);
		newPoly->cba = ((texture.cx)>>4) + ((texture.cy)<<6);
		newPoly->vert2 = i*2;
		newPoly->vert1 = (i*2+1)%6;
		newPoly->vert0 = (i*2+2)%6;
		newPoly->u0 = (u_char )texture.x[0];
		newPoly->v0 = (u_char )texture.y[0];
		newPoly->u1 = (u_char )texture.x[1];
		newPoly->v1 = (u_char )texture.y[1];
		newPoly->u2 = (u_char )texture.x[2];
		newPoly->v2 = (u_char )texture.y[2];
		SetColour0();
		SetColour1();
		SetColour2();

//		c0=0; c1=0; c2=2;
		newPoly = &newPoly[1];
		SetPrimitiveHeader(newPoly, TX_NS_GP_TRI, 1, 8, 9);
		newPoly->tsb = GetTPage(texture.pmode, 1, tPageX, tPageY);
		newPoly->cba = ((texture.cx)>>4) + ((texture.cy)<<6);
		newPoly->vert0 = i*2;
		newPoly->vert1 = (i*2+2)%6;
		newPoly->vert2 = 6;
		newPoly->u0 = (u_char )texture.x[0];
		newPoly->v0 = (u_char )texture.y[0];
		newPoly->u1 = (u_char )texture.x[1];
		newPoly->v1 = (u_char )texture.y[1];
		newPoly->u2 = (u_char )texture.x[2];
		newPoly->v2 = (u_char )texture.y[2];
		SetColour0();
		SetColour1();
		SetColour2();

		newPoly = &newPoly[1];
		SetPrimitiveHeader(newPoly, TX_NS_GP_TRI, 1, 8, 9);
		newPoly->tsb = GetTPage(texture.pmode, 1, tPageX, tPageY);
		newPoly->cba = ((texture.cx)>>4) + ((texture.cy)<<6);
		newPoly->vert2 = i*2;
		newPoly->vert1 = (i*2+2)%6;
		newPoly->vert0 = 6;
		newPoly->u0 = (u_char )texture.x[0];
		newPoly->v0 = (u_char )texture.y[0];
		newPoly->u1 = (u_char )texture.x[1];
		newPoly->v1 = (u_char )texture.y[1];
		newPoly->u2 = (u_char )texture.x[2];
		newPoly->v2 = (u_char )texture.y[2];
		SetColour0();
		SetColour1();
		SetColour2();
		newPoly = &newPoly[1];
	}
}


void SetNS_GP_QUAD(NS_GP_QUAD_FACE *newPoly, u_short v0, u_short v1, u_short v2, u_short v3, u_short c0, u_short c1, u_short c2, u_short c3) {
	SetPrimitiveHeader(newPoly, NS_GP_QUAD, 1, 6, 8);
	newPoly->mode2 = NS_GP_QUAD;
	newPoly->vert0 = v0;
	newPoly->vert1 = v1;
	newPoly->vert2 = v2;
	newPoly->vert3 = v3;
	SetColour0();
	SetColour1();
	SetColour2();
	SetColour3();
}
