#include <libps.h>

//#define NS_FP_QUAD (0x29)
#define TX_NS_FP_QUAD (0x2d)
#define TX_NS_FP_TRI (0x25)
#define TX_NS_GP_TRI (0x35)
#define NS_GP_QUAD (0x39)

//------------------------------------
// Structures
//------------------------------------

typedef struct {
	u_long id;
	u_long flag;
	u_long nobj;
} HEADER;

typedef struct {
	u_long *vert_top;
	u_long n_vert;
	u_long *normal_top;
	u_long n_normal;
	u_long *primitive_top;
	u_long n_primitive;
	long scale;
} OBJECT;

typedef struct {
	short vx, vy, vz;
	short padding;
} VERTEX;

typedef struct {
	short nx, ny, nz;
	short padding;
} NORMAL;

typedef struct {
	u_char r, g, b;
} COLOUR;

typedef struct {
	u_char x[4], y[4];
	int pmode;
	u_short cx, cy, px, py;
} TEXTURE;

// reflect model type
typedef struct {
	u_char olen, ilen, flag, mode;
	u_char u0, v0;
	u_short cba;
	u_char u1, v1;
	u_short tsb;
	u_char u2, v2;
	u_short padding0;
	u_short norm0, vert0;
	u_short norm1, vert1;
	u_short norm2, vert2;
} TX_GP_TRI_FACE;

/*typedef struct {
	u_char olen, ilen, flag, mode;
	u_char u0, v0; u_short cba;
	u_char u1, v1; u_short tsb;
	u_char u2, v2; u_short pad0;
	u_char u3, v3; u_short pad1;
	u_char r0, g0, b0, pad2;
	u_short vert0, vert1, vert2, vert3;
} TX_NS_FP_QUAD_FACE;
*/

// Track type
typedef struct {
	u_char olen, ilen, flag, mode;
	u_char u0, v0; u_short cba;
	u_char u1, v1; u_short tsb;
	u_char u2, v2; u_short pad0;
	u_char r0, g0, b0, pad1;
	u_short vert0, vert1, vert2, pad2;
} TX_NS_FP_TRI_FACE;

// Flame type
typedef struct {
	u_char olen, ilen, flag, mode;
	u_char u0, v0; u_short cba;
	u_char u1, v1; u_short tsb;
	u_char u2, v2; u_short pad0;
	u_char r0, g0, b0, pad1;
	u_char r1, g1, b1, pad2;
	u_char r2, g2, b2, pad3;
	u_short vert0, vert1, vert2, pad4;
} TX_NS_GP_TRI_FACE;

// Background type
typedef struct {
	u_char olen, ilen, flag, mode;
	u_char r0, g0, b0, mode2;
	u_char r1, g1, b1, pad0;
	u_char r2, g2, b2, pad1;
	u_char r3, g3, b3, pad2;
	u_short vert0, vert1, vert2, vert3;
} NS_GP_QUAD_FACE;

//------------------------------------
// Macro's
//------------------------------------

#define SetTmdHeader(h) \
	(h)->id = 0x41, \
	(h)->flag = 1, \
	(h)->nobj = 1

#define SetObjectData(o) \
	(o)->vert_top = VERTEX_START, \
	(o)->n_vert = VERTEX_QUANTITY, \
	(o)->normal_top = NORMAL_START, \
	(o)->n_normal = NORMAL_QUANTITY, \
	(o)->primitive_top = PRIMITIVE_START, \
	(o)->n_primitive = PRIMITIVE_QUANTITY, \
	(o)->scale = 0

#define SetPrimitiveHeader(h, _m, _f, _i, _o) \
	(h)->mode = (_m), \
	(h)->flag = (_f), \
	(h)->ilen = (_i), \
	(h)->olen = (_o)

#define SetColour0() \
	newPoly->r0 = (COLOUR_LUT+c0)->r, \
	newPoly->g0 = (COLOUR_LUT+c0)->g, \
	newPoly->b0 = (COLOUR_LUT+c0)->b

#define SetColour1() \
	newPoly->r1 = (COLOUR_LUT+c1)->r, \
	newPoly->g1 = (COLOUR_LUT+c1)->g, \
	newPoly->b1 = (COLOUR_LUT+c1)->b

#define SetColour2() \
	newPoly->r2 = (COLOUR_LUT+c2)->r, \
	newPoly->g2 = (COLOUR_LUT+c2)->g, \
	newPoly->b2 = (COLOUR_LUT+c2)->b

#define SetColour3() \
	newPoly->r3 = (COLOUR_LUT+c3)->r, \
	newPoly->g3 = (COLOUR_LUT+c3)->g, \
	newPoly->b3 = (COLOUR_LUT+c3)->b

#define SetVertex(v, _x, _y, _z) \
	(v)->vx = (_x), \
	(v)->vy = (_y), \
	(v)->vz = (_z)

#define SetNormal(n, _x, _y, _z) \
	(n)->nx = (_x), \
	(n)->ny = (_y), \
	(n)->nz = (_z)

#define SetColour(c, _r, _g, _b) \
	(c)->r = (_r), \
	(c)->g = (_g), \
	(c)->b = (_b)


//------------------------------------
// Function types
//------------------------------------

void PrepareTMD(VERTEX *vertex, COLOUR *colour, TEXTURE *texture);
//void SetNS_FP_QUAD(NS_FP_QUAD_FACE *newPoly, u_short v0, u_short v1, u_short v2, u_short v3, u_short c0);
void MakeSegment(TX_NS_FP_TRI_FACE *newPoly, u_short v0, u_short v1, u_short v2, u_short v3, u_short c0, int tex);
void MakeFlame(TX_NS_GP_TRI_FACE *newPoly);
void SetNS_GP_QUAD(NS_GP_QUAD_FACE *newPoly, u_short v0, u_short v1, u_short v2, u_short v3, u_short c0, u_short c1, u_short c2, u_short c3);
void SetTexture(TEXTURE *t, u_short tx, u_short ty, u_char _x0, u_char _y0, u_char _x1, u_char _y1, u_char _x2, u_char _y2, u_char _x3, u_char _y3, int _pmode, u_short _cx, u_short _cy);
