//Time traveller
//Rupert Vandervell
//rupertv@clickmedia.co.uk
//started 20/2/99
//Special thanks to Jonathan Ries for initial inspiration

// -----------------------------------------------
// Includes
// -----------------------------------------------

#include <libps.h>
#include "pad.h"

// -----------------------------------------------
// Defines
// -----------------------------------------------

#define MAX_SPRITES  (2+1)
#define SCREEN_WIDTH (320)
#define SCREEN_HEIGHT (240)
#define ManAddress 0X80150000
#define BgAddress 0x80110220
#define OT_LENGTH	1

// -----------------------------------------------
// Function Prototypes
// -----------------------------------------------

void initSprites ();
static long pad_read(GsSPRITE *sprt);    /* Controller state analysis */
static u_long PadRead(long id);         /* Controller state reading */

// -----------------------------------------------
// Initialise Structures
// -----------------------------------------------

// Ordering table variables
GsOT			WorldOT[2];
GsOT_TAG		OTTags[2][1<<OT_LENGTH];
int			activeBuff;

// Primitive related vaiables
PACKET		GpuPacketArea[2][MAX_SPRITES*sizeof(GsSPRITE)];


GsSPRITE		*sp;
GsSPRITE		bg;
int animate;


volatile u_char *bb0, *bb1; 	/* Controller related variables */


//------------------------
//MAIN
//------------------------

void main(void)
{

	int	i;
	long	j;
	int frames = 8; 			// determines when to show next animation frame

	// Initialise the drawing system
   SetVideoMode (MODE_PAL);
	GsInitGraph(SCREEN_WIDTH,SCREEN_HEIGHT,4,0,0);
	GsDefDispBuff(0,0,0,SCREEN_HEIGHT);

		
	// Initialise the ordering table
	for (i=0;i<2;i++)
		{
		WorldOT[i].length = OT_LENGTH;
		WorldOT[i].org = OTTags[i];
		}

	// Initialise the sprite
	initSprites();

   		  // set up the controller pad
		  GetPadBuf(&bb0, &bb1);

while (1)

	{
		  // make call to padread here, passing pointer to sprite
		  if ((j = pad_read(sp)) == -1)
					 break;		// exits if SELECT is pressed

		  activeBuff = GsGetActiveBuff();
		  GsSetWorkBase( (PACKET*)GpuPacketArea[activeBuff]);
		  GsClearOt(0,0,&WorldOT[activeBuff]);
		  GsSortSprite(sp,&WorldOT[activeBuff],0);
		  GsSortSprite(&bg,&WorldOT[activeBuff],0);


		  // changes u value of sprite, this animates man
		  if (animate == 1)
		  {      frames--;
		  if (frames <= 0)
		  {
		  frames = 8;
		  sp->u = sp->u + 64;


		  }

		  animate = 0;
						}

		  if (sp->u >= 256)  // resets animation to frame 1 if past frame 4
		  sp->u = 0;



		  DrawSync(0);
		  VSync(0);
		  GsSwapDispBuff();
		  GsSortClear(0, 0, 0,&WorldOT[activeBuff]);
		  GsDrawOt(&WorldOT[activeBuff]);

		  }
		  ResetGraph(3);

}   //end of main



//
// Sprite initialisation routine
//

void initSprites()
	{
	RECT		rect;
	GsIMAGE	tim_data;
	RECT		rect2;
	GsIMAGE	tim_data2;


	GsGetTimInfo ((u_long *)(ManAddress+4),&tim_data);

	rect.x = tim_data.px;							// x pos in frame buffer
	rect.y = tim_data.py;							// y pos in frame buffer
	rect.w = tim_data.pw;							// width of image
	rect.h = tim_data.ph;							// height of image
	LoadImage(&rect, tim_data.pixel);			// load data into frame buffer

	rect.x = tim_data.cx;							// x pos in frame buffer
	rect.y = tim_data.cy;							// y pos in frame buffer
	rect.w = tim_data.cw;							// width of CLUT
	rect.h = tim_data.ch;							// height of CLUT
	LoadImage(&rect, tim_data.clut);				// load data into frame buffer

	// Initialise sprite structure
	// set up the alien
	sp->attribute = 1<<24;	 // sprite attribute - 8 bit
	sp->x = 120;   //x position on screen
	sp->y = 120;   //y position on screen
	sp->w = 64;   //width of sprite area from 0
	sp->h = 64;   //height of sprite area from 0
	sp->tpage = GetTPage(0,0, tim_data.px, tim_data.py);
	sp->u = 0;
	sp->v = 0;
	sp->cx = tim_data.cx;
	sp->cy = tim_data.cy;
	sp->r = 128;
	sp->g = 128;
	sp->b = 128;
	sp->mx = 0;
	sp->my = 0;
	sp->scalex = ONE;
	sp->scaley = ONE;
	sp->rotate = 0;


	//initialise the bg

	GsGetTimInfo ((u_long *)(BgAddress+4),&tim_data2);

	rect2.x = tim_data2.px;
	rect2.y = tim_data2.py;
	rect2.w = tim_data2.pw;
	rect2.h = tim_data2.ph;
	LoadImage(&rect2, tim_data2.pixel);

	rect2.x = tim_data2.cx;
	rect2.y = tim_data2.cy;
	rect2.w = tim_data2.cw;
	rect2.h = tim_data2.ch;
	LoadImage(&rect2, tim_data2.clut);

	bg.attribute = 1<<24;
	bg.x = ((SCREEN_WIDTH/2)-(tim_data2.pw));
	bg.y = ((SCREEN_HEIGHT/2)-(tim_data2.ph/2));
	bg.w = (tim_data2.pw*2);
	bg.h = tim_data2.ph;
	bg.tpage = GetTPage(1,0, tim_data2.px, tim_data2.py);
	bg.u = 0;
	bg.v = 0;
	bg.cx = tim_data2.cx;
	bg.cy = tim_data2.cy;
	bg.r = 128;
	bg.g = 128;
	bg.b = 128;
	bg.mx = 0;
	bg.my = 0;
	bg.scalex = ONE;
	bg.scaley = ONE;
	bg.rotate = 0;

	DrawSync(0);
	} // end of sprite initialisation




   	/* Analysis of controller state */

static long pad_read(GsSPRITE *sprt)
{
	u_long padd = PadRead(1);	/* Controller reading */



		  if (padd & PADLleft)
		  {
					 sprt->v = 64;
					 sprt->x -= 3; /* D-pad left */

					 if (sprt->x <=-10)   //this loops the sprite to the reverse side of the screen
						  {
							sprt->x = 280;
							}
					 animate = 1;}



		  if (padd & PADLright)
		  {
					 sprt->v = 0;
					 sprt->x += 3; /* D-pad right */

					 if (sprt->x >280) //this loops the sprite to the reverse side of the screen
						  {
							sprt->x = 0;
							}
					 animate =1;}




	if (padd & PADL1)
		while (PadRead(1)&PADL1);	/* Pause */

	if(padd & PADselect)
					 return(-1);           /* Program termination */

		  limitRange(sprt->x, -10, 280);
		  limitRange(sprt->y, -10, 208);  /* n is given value 1<=n<=208 */

		  return(0);
}





/* Controller state reading */
static u_long PadRead(long id)
{
	return(~(*(bb0+3) | *(bb0+2) << 8 | *(bb1+3) << 16 | *(bb1+2) << 24));
}
